local Time = Game.Time
local Delay = 1
local ReadyTime = Time()

function Create()
end

function Update(timePassed)
	if Time() > ReadyTime then
		PerformUpdate()
		ReadyTime = ReadyTime + Delay
	end
end

function PerformUpdate()
	if Object.GetProperty(this, "CanStartCremation") == true then
		if Object.GetProperty(this, "CremationJobDispatched") == nil then
			Game.DebugOut("Dispatching job CrematePrisonerCorpse")
			this.CreateJob("CrematePrisonerCorpse")
			Object.SetProperty(this, "CremationJobDispatched", true)
		end
	else
		local cremationOvens = this.GetNearbyObjects("CremationOven", 2)
		for co, range in pairs(cremationOvens) do
			Game.DebugOut("CremationOven detected nearby @ distance "..range)
			Object.SetProperty(this, "CanStartCremation", true)
			break
		end
	end
end

function JobComplete_CrematePrisonerCorpse()
	local x = this.Pos.x
	local y = this.Pos.y
	this.Delete()
	local ashes = Object.Spawn("Garbage", x, y)
	local velX = -1.0 + math.random() + math.random()
    local velY = -1.0 + math.random() + math.random()
    ashes.ApplyVelocity(velX, velY)
    Game.DebugOut("Cremation completed, replacing with Garbage @ "..x..", "..y)
end